/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2008 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.action;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;

import jp.mosp.human.dao.MKihonDao;
import jp.mosp.human.dto.MKihonDto;

import jp.mosp.kintai.action.AttendanceTotalAction;

import jp.mosp.payroll.dao.CompileAmendmentDao;
import jp.mosp.payroll.dto.CompileAmendmentDto;
import jp.mosp.payroll.vo.AttendanceCalculateMenuVo;
import jp.mosp.payroll.vo.CompileAmendmentListVo;

public class CompileAmendmentListAction extends AttendanceTotalAction {

	// R}h
	private static final String CMD_AMENDMENT_LIST_SHOW 		= "P1040";
	private static final String CMD_AMENDMENT_LIST_SEARCH 	= "P1041";
	public  static final String CMD_AMENDMENT_LIST_RE_SEARCH 	= "P1042";
	private static final String CMD_AMENDMENT_LIST_SORT 		= "P1043";

	/**
	 * RXgN^
	 */
	public CompileAmendmentListAction() {
		super();
	}

	public void action() throws Exception {
		// RlNV擾
		getConnection();
		// PAYROLLmF
		confirmPayrollAuth();
		// VO̎擾
		CompileAmendmentListVo vo;
		Object obj = session.getAttribute(MospConst.ATT_FORMER_VO);
		if (obj instanceof CompileAmendmentListVo) {
			vo = (CompileAmendmentListVo) obj;
			vo.clearMessage();
			vo.clearErrField();
		} else {
			vo = new CompileAmendmentListVo();
		}
		vo.clearMessage();
		vo.clearErrField();
		vo.initVo(cfg, msg, cmd, aspUser, user);
		// VOyуtH[hURL̐ݒ
		setVo(vo);
		setUrl(vo.getRetUrl());
		session.setAttribute(MospConst.ATT_FORMER_VO, vo);
		// [U[擾
		getInfo(user.getUserId());
		// v_E擾
		setPulldownList(vo);
		// R}h̏
		if (cmd.equals(CMD_AMENDMENT_LIST_SHOW)) {
			// \
			// WvN
			vo.setPltYear(String.valueOf(MospUtility.getYear(getCalcMonth())));
			// Wv
			vo.setPltMonth(String.valueOf(MospUtility.getMonth(getCalcMonth())));
			// lɃZbg
			vo.setSearchmode(CompileAmendmentListVo.SEARCH_OFF);
		} else if (cmd.equals(CMD_AMENDMENT_LIST_SEARCH)) {
			// 
			vo.setParams(request);
			serachEmployeeList(vo);
			vo.setFormerKey(vo.KEY_K_CODE);
			vo.setIsAscending(true);
			vo.initListInfo();
			// ɃZbg
			vo.setSearchmode(CompileAmendmentListVo.SEARCH_ON);
		} else if (cmd.equals(CMD_AMENDMENT_LIST_RE_SEARCH)) {
			// Č
			session.removeAttribute(MospConst.ATT_DTO);
			if(vo.getSearchmode() == CompileAmendmentListVo.SEARCH_ON){
				serachEmployeeList(vo);
				vo.setPageButton();
				sortList(vo);
			} else {
				// ΑӏWv
				setCompileInfo(vo);
				serachEmployeeList(vo);
				vo.setFormerKey(vo.KEY_K_CODE);
				vo.setIsAscending(true);
				vo.initListInfo();
				// ɃZbg
				vo.setSearchmode(CompileAmendmentListVo.SEARCH_ON);
				sortList(vo);
			}
		} else if (cmd.equals(CMD_AMENDMENT_LIST_SORT)) {
			// \[g
			sortList(key1, vo);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}

	/**
	 * v_EXgݒ
	 * @param vo
	 * @throws Exception
	 */
	private void setPulldownList(CompileAmendmentListVo vo) throws Exception {
		// ΑӏF@\mF
		if (isAttendanceApprovalFunction()) {
			vo.setMode(CompileAmendmentListVo.MODE_POSSIBLE);
		} else {
			vo.setMode(CompileAmendmentListVo.MODE_IMPOSSIBLE);		
		}
		// Xg
		vo.aryPltSectionAll   = getSectionArrayAll();
		// Xg̃Zbg
		if (hasCalculateAuth()) {
			vo.aryPltSection = util.addArrayFirstRowValue(
					getSectionArrayAll(),
					CommonConst.NAM_COMMON_STRING_INITIAL_VALUE,
					CommonConst.NAM_ALL_SECTION);
		} else {
			vo.aryPltSection = getSectionArrayForManager();
		}
		// \
		Date current = getCalcMonth();
		// NXg擾
		vo.aryPltYear  = util.getYearArray(MospUtility.getYear (current), 1, 1);
		vo.aryPltMonth = util.getMonthArray();
		// FL
		if (isAttendanceApprovalFunction()) {
			vo.aryPltApprovalFlag = util.addArrayFirstRowSpace(util.getExistenceArray());			
		} else {
			vo.aryPltApprovalFlag = util.getBlankArray();	
		}
		// vZL
		vo.aryPltCompileFlag = util.addArrayFirstRowSpace(util.getExistenceArray());
	}

	/**
	 * ЈXg
	 * @param vo VoCX^X
	 * @throws Exception
	 */
	private void serachEmployeeList(CompileAmendmentListVo vo) throws Exception {
		// DBRlNV̎擾
		if (conn == null) {
			getConnection();
		}
		// Wv擾
		Date targetMonth = util.getFirstDateOfMonth(vo.getPltYear(), vo.getPltMonth());
		// ͈͎擾
		int startDate = util.convDateToInteger(getStartDate(targetMonth));
		// IЈꗗ
		MKihonDao mKihonDao = new MKihonDao();
		mKihonDao.initDao(cfg, cmd, aspUser, user, conn);
		List<MKihonDto> mKihonList = mKihonDao.findForCondition(
				vo.getTxtKCode(),
				vo.getTxtKName(),
				vo.getPltSection(),
				mKihon.getJCode(),
				mKihon.getKCode(),
				mospUser.getDataLevel(),
				startDate
		);
		// ΑӏWv
		CompileAmendmentDao mKintaiDao = new CompileAmendmentDao();
		mKintaiDao.initDao(cfg, cmd, aspUser, user, conn);
		List<CompileAmendmentDto> mKintaiList = new ArrayList<CompileAmendmentDto>();
		Iterator<MKihonDto> it = mKihonList.iterator();
		while (it.hasNext()) {
			MKihonDto mKihonDto = (MKihonDto) it.next();
			CompileAmendmentDto cAmendmentDto = mKintaiDao.findForCondition(
					mKihonDto.getKCode(),
					util.convDateToStringYearMonthShort(targetMonth),
					mKihonDto.getSCode()
			);
			// Wvݒ
			cAmendmentDto = setCompileFlag(cAmendmentDto, mKihonDto);
			// WvL
			String isCompile = util.returnTrueIsOn(cAmendmentDto.getCompileflag());
			// ΑӏF@\mF
			if (vo.getMode() == CompileAmendmentListVo.MODE_POSSIBLE) {
				// FL
				cAmendmentDto.setApprovalFlag(checkApproval(cAmendmentDto, targetMonth));
				// FL
				String isAllAprooved = util.returnTrueIsOff(cAmendmentDto.getApprovalFlag());
				// WvI
				if (vo.getEscPltCompile().equals(isCompile)) {
					// FI
					if (vo.getEscPltApproval().equals(isAllAprooved)) {
						mKintaiList.add(cAmendmentDto);
					} 
					// SȈꍇ
					else if (vo.getEscPltApproval().equals("")) {
						mKintaiList.add(cAmendmentDto);
					}
				} 
				// WvSȈꍇ
				else if (vo.getEscPltCompile().equals("")) {
					// FI
					if (vo.getEscPltApproval().equals(isAllAprooved)) {
						mKintaiList.add(cAmendmentDto);
					} 
					// SȈꍇ				
					else if (vo.getEscPltApproval().equals("")) {
						mKintaiList.add(cAmendmentDto);
					}
				}
			} else {
				// WvIASȈꍇ
				if (vo.getEscPltCompile().equals(isCompile) ||
						vo.getEscPltCompile().equals("")) {
					mKintaiList.add(cAmendmentDto);
				}
			}
		}
		// VOݒ
		vo.setFields(mKintaiList);
		// IN
		vo.setHidSelectDate(util.convDateToStringYearMonthShort(targetMonth));
		// Ώۂꍇ̃bZ[Wݒ
		if (vo.getAryCompile().length == 0) {
			vo.addErrMessage(MospUtility.getMessage(msg, MospConst.MSG_NO_DATA, ""));
		}
	}

	/**
	 * vZmF
	 * @param dto ΏDTO
	 * @param mKihonDto l{DTO
	 * @return dto ΏDTO
	 * @throws Exception
	 */
	private CompileAmendmentDto setCompileFlag(CompileAmendmentDto dto, MKihonDto mKihonDto) throws Exception {
		if (dto == null) {
			dto = new CompileAmendmentDto();
			dto.setKCode(mKihonDto.getKCode());
			dto.setKName(mKihonDto.getSimei());
			dto.setSCode(mKihonDto.getSCode());
			// Wv
			dto.setCompileflag(true);
		} else {
			// Wv
			dto.setCompileflag(false);
		}
		return dto;
	}

	/**
	 * ΑӏWṽZbg
	 * @param vo
	 * @throws Exception
	 */
	private void setCompileInfo(CompileAmendmentListVo vo) throws Exception {
		// WvR[h
		vo.setPltSection((String)request.getAttribute(AttendanceCalculateMenuVo.COMPILE_SECTION));
		// WvЈR[h
		vo.setTxtKCode((String)request.getAttribute(AttendanceCalculateMenuVo.COMPILE_K_CODE));
		// WvN
		vo.setPltYear(String.valueOf(MospUtility.getYear(getCalcMonth())));
		// Wv
		vo.setPltMonth(String.valueOf(MospUtility.getMonth(getCalcMonth())));
	}

	/**
	 * \[g
	 * @param key \[gL[
	 * @param vo \[gΏList܂VO
	 * @throws MospException
	 */
	private void sortList(String key, CompileAmendmentListVo vo) throws MospException {
		vo.sortList(key, getComparator(key, vo));
		vo.setFields(vo.getList());
	}

	/**
	 * \[g(VÕL[Ń\[g)
	 * @param vo \[gΏList܂VO
	 * @throws MospException
	 */
	private void sortList(CompileAmendmentListVo vo) throws MospException {
		vo.sortList(getComparator(vo.getFormerKey(), vo));
		vo.setFields(vo.getList());
	}

	/**
	 * rNX擾
	 * @param key \[gL[
	 * @param vo \[gΏList܂VO
	 * @throws MospException
	 */
	private Comparator getComparator(String key, CompileAmendmentListVo vo) throws MospException {
		Comparator comp = null;
		if (key.equals(vo.KEY_K_CODE)) {
			comp = new CompKCode();
		} else if (key.equals(vo.KEY_K_NAME)) {
			comp = new CompKName();
		} else if (key.equals(vo.KEY_SECTION)) {
			comp = new CompSection();
		} else {
			throw new MospException(MospConst.EX_SORTKEY_INVALID);
		}
		return comp;
	}

	/**
	 * ЈR[hɂrNX
	 */
	protected static class CompKCode implements Comparator, Serializable {
		private static final long serialVersionUID = 2785426316163131119L;
		public int compare(Object obj1, Object obj2) {
			CompileAmendmentDto dto1 = (CompileAmendmentDto)obj1;
			CompileAmendmentDto dto2 = (CompileAmendmentDto)obj2;
			return dto1.getKCode().compareTo(dto2.getKCode());
		}
	}

	/**
	 * ЈɂrNX
	 */
	protected static class CompKName implements Comparator, Serializable {
		private static final long serialVersionUID = 6920023209991067840L;
		public int compare(Object obj1, Object obj2) {
			CompileAmendmentDto dto1 = (CompileAmendmentDto)obj1;
			CompileAmendmentDto dto2 = (CompileAmendmentDto)obj2;
			return dto1.getKName().compareTo(dto2.getKName());
		}
	}

	/**
	 * ɂrNX
	 */
	protected static class CompSection implements Comparator, Serializable {
		private static final long serialVersionUID = 8039660004898020825L;
		public int compare(Object obj1, Object obj2) {
			CompileAmendmentDto dto1 = (CompileAmendmentDto)obj1;
			CompileAmendmentDto dto2 = (CompileAmendmentDto)obj2;
			return dto1.getSCode().compareTo(dto2.getSCode());
		}
	}

}
